﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Win32;
using Winfoot_7_SDK;

namespace WinfootDefaultSystemPlugin.Controls.Strategy
{
    public interface IWaitToKillAppTimeoutStrategy
    {
        void Write(int i);
        WFRegistry Read();
        List<WFRegistry> BackUp();
    }

    public class WaitToKillAppTimeoutDefaultStrategy : ICorrespondenceOS, IWaitToKillAppTimeoutStrategy
    {
        public WaitToKillAppTimeoutDefaultStrategy()
        {
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,
#if DEBUG              
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
                                           OS.WindowsVista_SP2,
                                           OS.WindowsSeven
#endif
                                       };
        }

        private string RegName = "WaitToKillAppTimeout";

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion

        public void Write(int i)
        {
            RegistryKey registryKey =
                Registry.CurrentUser.CreateSubKey(
                    @"Control Panel\Desktop");

            registryKey.SetValue(RegName, i);
        }

        public WFRegistry Read()
        {
            RegistryKey registryKey =
                Registry.CurrentUser.OpenSubKey(
                    @"Control Panel\Desktop");

            return new WFRegistry(@"HKEY_CURRENT_USER\Control Panel\Desktop", RegName,
                              registryKey.GetValue(RegName, 20000), RegistryValueKind.DWord, RegOperation.KeyWrite);



        }

        public List<WFRegistry> BackUp()
        {
            return new List<WFRegistry> { Read() };
        }

    }

    public class WaitToKillAppTimeoutController
    {
        public WaitToKillAppTimeoutController(WaitToKillAppTimeout waitToKillAppTimeout,
                                                         IWaitToKillAppTimeoutStrategy strategy)
        {
            WaitToKillAppTimeout = waitToKillAppTimeout;
            Strategy = strategy;
        }

        public WaitToKillAppTimeout WaitToKillAppTimeout { get; set; }
        public IWaitToKillAppTimeoutStrategy Strategy { get; set; }

        public void Read()
        {
            WaitToKillAppTimeout.SetMenuShowDelayValue(Convert.ToInt32(Strategy.Read().Value));
        }

        public void Write()
        {
            Strategy.Write(WaitToKillAppTimeout.GetMenuShowDelayValue());
        }

        public List<WFRegistry> BackUp()
        {
            return Strategy.BackUp();
        }
    }
}
